using System;
using System.Diagnostics;

namespace Implab {
    class PromiseFuncReaction<TIn, TRet> : PromiseReaction<TIn> {
        readonly Deferred<TRet> m_next;

        public IPromise<TRet> Promise { 
            get { return m_next.Promise; }
        }

        public PromiseFuncReaction(Func<TIn, TRet> fulfilled, Func<Exception, TRet> rejected, IDispatcher dispatcher) : base(dispatcher) {
            m_next = new Deferred<TRet>(dispatcher);
            if (fulfilled != null)
                FulfilHandler = PromiseHandler.Create(fulfilled, m_next);

            if (rejected != null)
                RejectHandler = PromiseHandler.Create(rejected, m_next);
        }

        public PromiseFuncReaction(Func<TIn, IPromise<TRet>> fulfilled, Func<Exception, IPromise<TRet>> rejected, IDispatcher dispatcher) : base(dispatcher) {
            m_next = new Deferred<TRet>(dispatcher);
            if (fulfilled != null)
                FulfilHandler = PromiseHandler.Create(fulfilled, m_next);

            if (rejected != null)
                RejectHandler = PromiseHandler.Create(rejected, m_next);
        }

        public PromiseFuncReaction(Func<TIn, TRet> fulfilled, Func<Exception, IPromise<TRet>> rejected, IDispatcher dispatcher) : base(dispatcher) {
            m_next = new Deferred<TRet>(dispatcher);
            if (fulfilled != null)
                FulfilHandler = PromiseHandler.Create(fulfilled, m_next);

            if (rejected != null)
                RejectHandler = PromiseHandler.Create(rejected, m_next);
        }

        public PromiseFuncReaction(Func<TIn, IPromise<TRet>> fulfilled, Func<Exception, TRet> rejected, IDispatcher dispatcher) : base(dispatcher) {
            m_next = new Deferred<TRet>(dispatcher);
            if (fulfilled != null)
                FulfilHandler = PromiseHandler.Create(fulfilled, m_next);

            if (rejected != null)
                RejectHandler = PromiseHandler.Create(rejected, m_next);
        }

        protected override void DefaultReject(Exception reason) {
            m_next.Reject(reason);
        }

        protected override void DefaultResolve(TIn result) {
            m_next.Resolve((TRet)(object)result);
        }
    }
}